﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace CashierCrisis.Behaviors
{
    [DefaultProperty("Seconds")]
    public class Timer : Decorator
    {
        private DateTime endTime;
        [Category("Settings"),Description("How long this behavior's child will run")]
        public int Seconds { get; set; }

        public override Status Execute(Microsoft.Xna.Framework.GameTime gameTime)
        {
            if (endTime == null)
            {
                endTime = DateTime.Now.AddSeconds(Seconds);
            }

            if (endTime >= DateTime.Now)
            {
                return Completed;
            }

            return Child.Execute(gameTime);
        }
    }
}
